#! /usr/bin/python

import numpy as np
import matplotlib as mpl
import matplotlib.pyplot as plt
mpl.rcParams['svg.embed_char_paths'] = False


data17_1 = np.loadtxt("HSP17-7/conc1.dat", skiprows=7)
data17_2 = np.loadtxt("HSP17-7/conc2.dat", skiprows=7)
data17_3 = np.loadtxt("HSP17-7/conc3.dat", skiprows=7)
data17_1[:,1]/=np.max(data17_1[:,1])
data17_1[:,1]=np.log(data17_1[:,1])
data17_2[:,1]/=np.max(data17_2[:,1])
data17_2[:,1]=np.log(data17_2[:,1])
data17_3[:,1]/=np.max(data17_3[:,1])
data17_3[:,1]=np.log(data17_3[:,1])

data18_1 = np.loadtxt("HSP18-1/conc1.dat", skiprows=7)
data18_2 = np.loadtxt("HSP18-1/conc2.dat", skiprows=7)
data18_3 = np.loadtxt("HSP18-1/conc3.dat", skiprows=7)
data18_1[:,1]/=np.max(data18_1[:,1])
data18_1[:,1]=np.log(data18_1[:,1])
data18_2[:,1]/=np.max(data18_2[:,1])
data18_2[:,1]=np.log(data18_2[:,1])
data18_3[:,1]/=np.max(data18_3[:,1])
data18_3[:,1]=np.log(data18_3[:,1])


fig = plt.figure()
ax = fig.add_subplot(111)

ax.plot(data17_3[:,0], data17_3[:,1], "powderblue", label="17.7 conc3")
ax.plot(data17_2[:,0], data17_2[:,1], "deepskyblue", label="17.7 conc2")
ax.plot(data17_1[:,0], data17_1[:,1], "royalblue", label="17.7 conc1")

ax.plot(data18_3[:,0], data18_3[:,1], "peachpuff", label="18.1 conc3")
ax.plot(data18_2[:,0], data18_2[:,1], "tomato", label="18.1 conc2")
ax.plot(data18_1[:,0], data18_1[:,1], "brown", label="18.1 conc1")



ax.set_ylim([-8,0])
ax.set_xlim([0,0.35])

ax.set_xlabel("Q (1/A)")
ax.set_ylabel("log(norm(I(Q)))")

ax.legend()

plt.savefig("compare_177_181_all.svg")

plt.show()
